% Copyright 2016 Sandia Corporation. Under the terms of Contract DE-AC04-94AL85000 with Sandia
% Corporation, the U.S. Government retains certain rights in this software

% Redistribution and use in source and binary forms, with or without
% modification, are permitted provided that the following conditions are
% met:
% 
%     (1) Redistributions of source code must retain the above copyright
%     notice, this list of conditions and the following disclaimer. 
% 
%     (2) Redistributions in binary form must reproduce the above copyright
%     notice, this list of conditions and the following disclaimer in
%     the documentation and/or other materials provided with the
%     distribution.  
%     
%     (3)The name of the author may not be used to
%     endorse or promote products derived from this software without
%     specific prior written permission.
% 
% THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
% IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
% WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
% DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
% INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
% (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
% SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
% HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
% STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
% IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
% POSSIBILITY OF SUCH DAMAGE.

function deconData = despikeMedian(data,m)

%FUNCTION deconData = despikeMedian(data,m)
%
% PURPOSE:
%	despikeMedian.m is a simple implementation of a standard
%	median-filtering technique. It is included as a separate function for
%	completeness and symmetry with the other algorithms. 
%
% DEPENDENCIES:
%	-None-
%
% CLASSES:
%	-None-
%
% INPUTS:
%	data:
%		An m by n matrix, where each of the n columns corresponds to a 
%		spectrum. The data is expected to be contaminated with cosmic
%		spikes. 
%	m:
%		A variable specifying the size of the median filter, which is set
%		at 2*m+1. 
%
% OUTPUTS:
%	deconData:
%		An m by n matrix, where each of the n columns corresponds to a 
%		spectrum. In the median-filtered output, the cosmic spikes in the
%		original data have hopefully been suppressed. 
%
% REFERENCES:
%	-None-
%
% PROGRAMMER COMMENTS:
%	-None-
%
% LIMITATIONS:
%	Median-filtration is known to perturb the spectra, in particular
%	suppressing narrow spectral features and truncating peaks.
%	Additionally, it substantially alters the noise profile of the data. 

% Revision:
%	Sandia Hyper-UBS 1.0.0

%Calculate the median filterd version of the data. 
deconData = medfilt2(data,[2*m+1 1]);
